#!/bin/sh
LOGFILE=/media/sdcard/log.txt
DIR=/media/sdcard/original/
MINIMUM_SPACE=563200

if ! cd $DIR
then
    exit 2
fi

AVAILABLE_SPACE=$(df -k . | awk '{gsub("%",""); available=$4}; END {print available}')

if [ $MINIMUM_SPACE -gt $AVAILABLE_SPACE ]
then
    ls -rt | while read FILE
    do
        if [ -f $FILE ]
        then
            if rm -f $FILE
            then
                AVAILABLE_SPACE=$(df -k . | awk '{gsub("%",""); available=$4}; END {print available}')
                if [ $MINIMUM_SPACE -le $AVAILABLE_SPACE ]
                then
                    exit
                fi
            fi
        fi
    done
fi

if [ -f $LOGFILE ]
then
	echo "$(tail -10000 $LOGFILE)" > $LOGFILE
fi
